package com.phlx.anchor_collect_flutter;


import io.flutter.embedding.android.FlutterActivity;
import android.content.Intent;
import android.os.Bundle;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.embedding.engine.FlutterEngine;

public class MainActivity extends FlutterActivity {

    // 通道名称
    protected String channel = "通道名称";

    // 获取推送，发给flutter
    protected String payLoad = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // 获取自定义透传参数值
        Intent intent = getIntent();
        if (intent != null) {
            payLoad = intent.getStringExtra("payload");
        }
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);

        // 获取自定义透传参数值
        if (intent != null) {
            payLoad = intent.getStringExtra("payload");
        }
    }

    @Override
    public void configureFlutterEngine(FlutterEngine flutterEngine) {
        super.configureFlutterEngine(flutterEngine);

        payLoad = getIntent().getStringExtra("payload");

        try {
            // 通过MethodChannel调用通知flutter开启参数
            new MethodChannel(
                    flutterEngine.getDartExecutor().getBinaryMessenger(),
                    channel
            ).setMethodCallHandler(new MethodChannel.MethodCallHandler() {
                @Override
                public void onMethodCall(MethodCall call, MethodChannel.Result result) {
                    if (call.method.equals("getIntentData")) {
                        result.success(payLoad);
                    }
                }
            });

        } catch (Exception err) {}
    }
}



