import 'dart:convert';

import '../generated/json/base/json_field.dart';
import 'api_response.g.dart';

@JsonSerializable()
class ApiResponse<T> {
  late int code;
  late String msg;
  T? data;
  late List<T?> list;

  ApiResponse();

  factory ApiResponse.fromJson(Map<String, dynamic> json) =>
      $ApiResponseFromJson<T>(json);

  factory ApiResponse.fromJsonList(Map<String, dynamic> json) =>
      $ApiResponseFromJsonList<T>(json);

  Map<String, dynamic> toJson() => $ApiResponseToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}

@JsonSerializable()
class ApiResponseData {
  ApiResponseData();

  factory ApiResponseData.fromJson(Map<String, dynamic> json) =>
      $ApiResponseDataFromJson(json);

  Map<String, dynamic> toJson() => $ApiResponseDataToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}
