import 'dart:convert';

import '../generated/json/base/json_convert_content.dart';
import 'api_response.dart';

ApiResponse<T> $ApiResponseFromJson<T>(Map<String, dynamic> json) {
  final ApiResponse<T> apiResponse = ApiResponse<T>();
  final int? code = jsonConvert.convert<int>(json['code']);
  if (code != null) {
    apiResponse.code = code;
  }
  final String? msg = jsonConvert.convert<String>(json['msg']);
  if (msg != null) {
    apiResponse.msg = msg;
  }
  T? data;
  data = jsonConvert.convert<T>(json['data']);
  if (data != null) {
    apiResponse.data = data;
  }
  return apiResponse;
}

ApiResponse<T> $ApiResponseFromJsonList<T>(Map<String, dynamic> json) {
  final ApiResponse<T> apiResponse = ApiResponse<T>();
  final int? code = jsonConvert.convert<int>(json['code']);
  if (code != null) {
    apiResponse.code = code;
  }
  final String? msg = jsonConvert.convert<String>(json['msg']);
  if (msg != null) {
    apiResponse.msg = msg;
  }
  List<T?>? data;
  data = jsonConvert.convertList<T>(json['data']);
  if (data != null) {
    apiResponse.list = data;
  }
  return apiResponse;
}

Map<String, dynamic> $ApiResponseToJson(ApiResponse entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['code'] = entity.code;
  data['msg'] = entity.msg;
  data['data'] = entity.data.toJson();
  data['list'] = entity.data.toJson();
  return data;
}

extension ApiResponseExtension on ApiResponse {
  ApiResponse copyWith({
    int? code,
    String? msg,
    ApiResponseData? data,
  }) {
    return ApiResponse()
      ..code = code ?? this.code
      ..msg = msg ?? this.msg
      ..data = data ?? this.data
      ..list = list;
  }
}

ApiResponseData $ApiResponseDataFromJson(Map<String, dynamic> json) {
  final ApiResponseData apiResponseData = ApiResponseData();
  return apiResponseData;
}

Map<String, dynamic> $ApiResponseDataToJson(ApiResponseData entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  return data;
}

extension ApiResponseDataExtension on ApiResponseData {}
