

import 'package:get/get.dart';
import 'package:isar/isar.dart';

import '../models/cattle_resume_entity.dart';
import '../models/dict_entity.dart';
import '../models/user_model.dart';

/// 全局状态管理
class GlobalService extends GetxService {
  static GlobalService get to => Get.find();

  /// 本地数据库实例
  late Isar isar;

  /// 初始化
  Future<GlobalService> init() async {
    isar = await Isar.open([
      UserModelSchema,
      UserModelDeptSchema,
      UserModelRolesSchema,
      CattleResumeEntitySchema,
      DictEntitySchema,
    ], inspector: true);

    return this;
  }
}