import 'package:anchor_collect_flutter/generated/json/base/json_convert_content.dart';
import 'package:anchor_collect_flutter/models/dict_entity.dart';
import 'package:isar/isar.dart';


DictEntity $DictEntityFromJson(Map<String, dynamic> json) {
  final DictEntity dictEntity = DictEntity();
  final Id? id = jsonConvert.convert<Id>(json['id']);
  if (id != null) {
    dictEntity.id = id;
  }
  final String? dictCode = jsonConvert.convert<String>(json['dictCode']);
  if (dictCode != null) {
    dictEntity.dictCode = dictCode;
  }
  final String? dictSort = jsonConvert.convert<String>(json['dictSort']);
  if (dictSort != null) {
    dictEntity.dictSort = dictSort;
  }
  final String? dictLabel = jsonConvert.convert<String>(json['dictLabel']);
  if (dictLabel != null) {
    dictEntity.dictLabel = dictLabel;
  }
  final String? dictValue = jsonConvert.convert<String>(json['dictValue']);
  if (dictValue != null) {
    dictEntity.dictValue = dictValue;
  }
  final String? dictType = jsonConvert.convert<String>(json['dictType']);
  if (dictType != null) {
    dictEntity.dictType = dictType;
  }
  final String? cssClass = jsonConvert.convert<String>(json['cssClass']);
  if (cssClass != null) {
    dictEntity.cssClass = cssClass;
  }
  final String? listClass = jsonConvert.convert<String>(json['listClass']);
  if (listClass != null) {
    dictEntity.listClass = listClass;
  }
  final String? isDefault = jsonConvert.convert<String>(json['isDefault']);
  if (isDefault != null) {
    dictEntity.isDefault = isDefault;
  }
  final String? status = jsonConvert.convert<String>(json['status']);
  if (status != null) {
    dictEntity.status = status;
  }
  final String? createBy = jsonConvert.convert<String>(json['createBy']);
  if (createBy != null) {
    dictEntity.createBy = createBy;
  }
  final String? createTime = jsonConvert.convert<String>(json['createTime']);
  if (createTime != null) {
    dictEntity.createTime = createTime;
  }
  final String? updateBy = jsonConvert.convert<String>(json['updateBy']);
  if (updateBy != null) {
    dictEntity.updateBy = updateBy;
  }
  final String? updateTime = jsonConvert.convert<String>(json['updateTime']);
  if (updateTime != null) {
    dictEntity.updateTime = updateTime;
  }
  final String? remark = jsonConvert.convert<String>(json['remark']);
  if (remark != null) {
    dictEntity.remark = remark;
  }
  final String? deptName = jsonConvert.convert<String>(json['deptName']);
  if (deptName != null) {
    dictEntity.deptName = deptName;
  }
  return dictEntity;
}

Map<String, dynamic> $DictEntityToJson(DictEntity entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['id'] = entity.id;
  data['dictCode'] = entity.dictCode;
  data['dictSort'] = entity.dictSort;
  data['dictLabel'] = entity.dictLabel;
  data['dictValue'] = entity.dictValue;
  data['dictType'] = entity.dictType;
  data['cssClass'] = entity.cssClass;
  data['listClass'] = entity.listClass;
  data['isDefault'] = entity.isDefault;
  data['status'] = entity.status;
  data['createBy'] = entity.createBy;
  data['createTime'] = entity.createTime;
  data['updateBy'] = entity.updateBy;
  data['updateTime'] = entity.updateTime;
  data['remark'] = entity.remark;
  data['deptName'] = entity.deptName;
  return data;
}

extension DictEntityExtension on DictEntity {
  DictEntity copyWith({
    Id? id,
    String? dictCode,
    String? dictSort,
    String? dictLabel,
    String? dictValue,
    String? dictType,
    String? cssClass,
    String? listClass,
    String? isDefault,
    String? status,
    String? createBy,
    String? createTime,
    String? updateBy,
    String? updateTime,
    String? remark,
    String? deptName,
  }) {
    return DictEntity()
      ..id = id ?? this.id
      ..dictCode = dictCode ?? this.dictCode
      ..dictSort = dictSort ?? this.dictSort
      ..dictLabel = dictLabel ?? this.dictLabel
      ..dictValue = dictValue ?? this.dictValue
      ..dictType = dictType ?? this.dictType
      ..cssClass = cssClass ?? this.cssClass
      ..listClass = listClass ?? this.listClass
      ..isDefault = isDefault ?? this.isDefault
      ..status = status ?? this.status
      ..createBy = createBy ?? this.createBy
      ..createTime = createTime ?? this.createTime
      ..updateBy = updateBy ?? this.updateBy
      ..updateTime = updateTime ?? this.updateTime
      ..remark = remark ?? this.remark
      ..deptName = deptName ?? this.deptName;
  }
}