import 'package:anchor_collect_flutter/generated/json/base/json_convert_content.dart';
import 'package:anchor_collect_flutter/models/login_entity.dart';
import 'package:anchor_collect_flutter/models/user_model.dart';

import 'package:json_annotation/json_annotation.dart';


LoginEntity $LoginEntityFromJson(Map<String, dynamic> json) {
  final LoginEntity loginEntity = LoginEntity();
  final UserModel? user = jsonConvert.convert<UserModel>(json['user']);
  if (user != null) {
    loginEntity.user = user;
  }
  final String? token = jsonConvert.convert<String>(json['token']);
  if (token != null) {
    loginEntity.token = token;
  }
  return loginEntity;
}

Map<String, dynamic> $LoginEntityToJson(LoginEntity entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['user'] = entity.user.toJson();
  data['token'] = entity.token;
  return data;
}

extension LoginEntityExtension on LoginEntity {
  LoginEntity copyWith({
    UserModel? user,
    String? token,
  }) {
    return LoginEntity()
      ..user = user ?? this.user
      ..token = token ?? this.token;
  }
}