import 'package:anchor_collect_flutter/generated/json/base/json_convert_content.dart';
import 'package:anchor_collect_flutter/models/message.dart';


MessageModel $MessageModelFromJson(Map<String, dynamic> json) {
  final MessageModel messageModel = MessageModel();
  final String? id = jsonConvert.convert<String>(json['id']);
  if (id != null) {
    messageModel.id = id;
  }
  final String? state = jsonConvert.convert<String>(json['state']);
  if (state != null) {
    messageModel.state = state;
  }
  final int? num = jsonConvert.convert<int>(json['num']);
  if (num != null) {
    messageModel.num = num;
  }
  final String? title = jsonConvert.convert<String>(json['title']);
  if (title != null) {
    messageModel.title = title;
  }
  final String? type = jsonConvert.convert<String>(json['type']);
  if (type != null) {
    messageModel.type = type;
  }
  final String? createTime = jsonConvert.convert<String>(json['createTime']);
  if (createTime != null) {
    messageModel.createTime = createTime;
  }
  final String? detail = jsonConvert.convert<String>(json['detail']);
  if (detail != null) {
    messageModel.detail = detail;
  }
  return messageModel;
}

Map<String, dynamic> $MessageModelToJson(MessageModel entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['id'] = entity.id;
  data['state'] = entity.state;
  data['num'] = entity.num;
  data['title'] = entity.title;
  data['type'] = entity.type;
  data['createTime'] = entity.createTime;
  data['detail'] = entity.detail;
  return data;
}

extension MessageModelExtension on MessageModel {
  MessageModel copyWith({
    String? id,
    String? state,
    int? num,
    String? title,
    String? type,
    String? createTime,
    String? detail,
  }) {
    return MessageModel()
      ..id = id ?? this.id
      ..state = state ?? this.state
      ..num = num ?? this.num
      ..title = title ?? this.title
      ..type = type ?? this.type
      ..createTime = createTime ?? this.createTime
      ..detail = detail ?? this.detail;
  }
}