import 'package:anchor_collect_flutter/generated/json/base/json_convert_content.dart';
import 'package:anchor_collect_flutter/models/user_model.dart';
import 'dart:ffi';

import 'package:isar/isar.dart';



UserModel $UserModelFromJson(Map<String, dynamic> json) {
  final UserModel userModel = UserModel();
  final Id? id = jsonConvert.convert<Id>(json['id']);
  if (id != null) {
    userModel.id = id;
  }
  final String? userId = jsonConvert.convert<String>(json['userId']);
  if (userId != null) {
    userModel.userId = userId;
  }
  final String? deptId = jsonConvert.convert<String>(json['deptId']);
  if (deptId != null) {
    userModel.deptId = deptId;
  }
  final String? parentId = jsonConvert.convert<String>(json['parentId']);
  if (parentId != null) {
    userModel.parentId = parentId;
  }
  final String? roleId = jsonConvert.convert<String>(json['roleId']);
  if (roleId != null) {
    userModel.roleId = roleId;
  }
  final String? loginName = jsonConvert.convert<String>(json['loginName']);
  if (loginName != null) {
    userModel.loginName = loginName;
  }
  final String? userName = jsonConvert.convert<String>(json['userName']);
  if (userName != null) {
    userModel.userName = userName;
  }
  final String? userType = jsonConvert.convert<String>(json['userType']);
  if (userType != null) {
    userModel.userType = userType;
  }
  final String? email = jsonConvert.convert<String>(json['email']);
  if (email != null) {
    userModel.email = email;
  }
  final String? phonenumber = jsonConvert.convert<String>(json['phonenumber']);
  if (phonenumber != null) {
    userModel.phonenumber = phonenumber;
  }
  final String? sex = jsonConvert.convert<String>(json['sex']);
  if (sex != null) {
    userModel.sex = sex;
  }
  final String? avatar = jsonConvert.convert<String>(json['avatar']);
  if (avatar != null) {
    userModel.avatar = avatar;
  }
  final String? password = jsonConvert.convert<String>(json['password']);
  if (password != null) {
    userModel.password = password;
  }
  final String? salt = jsonConvert.convert<String>(json['salt']);
  if (salt != null) {
    userModel.salt = salt;
  }
  final String? status = jsonConvert.convert<String>(json['status']);
  if (status != null) {
    userModel.status = status;
  }
  final String? delFlag = jsonConvert.convert<String>(json['delFlag']);
  if (delFlag != null) {
    userModel.delFlag = delFlag;
  }
  final String? loginIp = jsonConvert.convert<String>(json['loginIp']);
  if (loginIp != null) {
    userModel.loginIp = loginIp;
  }
  final String? loginDate = jsonConvert.convert<String>(json['loginDate']);
  if (loginDate != null) {
    userModel.loginDate = loginDate;
  }
  final String? pwdUpdateDate = jsonConvert.convert<String>(json['pwdUpdateDate']);
  if (pwdUpdateDate != null) {
    userModel.pwdUpdateDate = pwdUpdateDate;
  }
  final String? createBy = jsonConvert.convert<String>(json['createBy']);
  if (createBy != null) {
    userModel.createBy = createBy;
  }
  final String? createTime = jsonConvert.convert<String>(json['createTime']);
  if (createTime != null) {
    userModel.createTime = createTime;
  }
  final String? updateBy = jsonConvert.convert<String>(json['updateBy']);
  if (updateBy != null) {
    userModel.updateBy = updateBy;
  }
  final String? updateTime = jsonConvert.convert<String>(json['updateTime']);
  if (updateTime != null) {
    userModel.updateTime = updateTime;
  }
  final String? remark = jsonConvert.convert<String>(json['remark']);
  if (remark != null) {
    userModel.remark = remark;
  }
  final UserModelParams? params = jsonConvert.convert<UserModelParams>(json['params']);
  if (params != null) {
    userModel.params = params;
  }
  final String? registrationNo = jsonConvert.convert<String>(json['registrationNo']);
  if (registrationNo != null) {
    userModel.registrationNo = registrationNo;
  }
  final String? individualNo = jsonConvert.convert<String>(json['individualNo']);
  if (individualNo != null) {
    userModel.individualNo = individualNo;
  }
  final String? deptName = jsonConvert.convert<String>(json['deptName']);
  if (deptName != null) {
    userModel.deptName = deptName;
  }
  final String? clientId = jsonConvert.convert<String>(json['clientId']);
  if (clientId != null) {
    userModel.clientId = clientId;
  }
  final String? appType = jsonConvert.convert<String>(json['appType']);
  if (appType != null) {
    userModel.appType = appType;
  }
  final UserModelDept? dept = jsonConvert.convert<UserModelDept>(json['dept']);
  if (dept != null) {
    userModel.dept = dept;
  }
  final List<UserModelRoles>? roles = (json['roles'] as List<dynamic>?)?.map(
          (e) => jsonConvert.convert<UserModelRoles>(e) as UserModelRoles).toList();
  if (roles != null) {
    userModel.roles = roles;
  }
  final String? roleIds = jsonConvert.convert<String>(json['roleIds']);
  if (roleIds != null) {
    userModel.roleIds = roleIds;
  }
  final String? postIds = jsonConvert.convert<String>(json['postIds']);
  if (postIds != null) {
    userModel.postIds = postIds;
  }
  final bool? admin = jsonConvert.convert<bool>(json['admin']);
  if (admin != null) {
    userModel.admin = admin;
  }
  return userModel;
}

Map<String, dynamic> $UserModelToJson(UserModel entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['id'] = entity.id;
  data['userId'] = entity.userId;
  data['deptId'] = entity.deptId;
  data['parentId'] = entity.parentId;
  data['roleId'] = entity.roleId;
  data['loginName'] = entity.loginName;
  data['userName'] = entity.userName;
  data['userType'] = entity.userType;
  data['email'] = entity.email;
  data['phonenumber'] = entity.phonenumber;
  data['sex'] = entity.sex;
  data['avatar'] = entity.avatar;
  data['password'] = entity.password;
  data['salt'] = entity.salt;
  data['status'] = entity.status;
  data['delFlag'] = entity.delFlag;
  data['loginIp'] = entity.loginIp;
  data['loginDate'] = entity.loginDate;
  data['pwdUpdateDate'] = entity.pwdUpdateDate;
  data['createBy'] = entity.createBy;
  data['createTime'] = entity.createTime;
  data['updateBy'] = entity.updateBy;
  data['updateTime'] = entity.updateTime;
  data['remark'] = entity.remark;
  data['params'] = entity.params?.toJson();
  data['registrationNo'] = entity.registrationNo;
  data['individualNo'] = entity.individualNo;
  data['deptName'] = entity.deptName;
  data['clientId'] = entity.clientId;
  data['appType'] = entity.appType;
  data['dept'] = entity.dept?.toJson();
  data['roles'] = entity.roles?.map((v) => v.toJson()).toList();
  data['roleIds'] = entity.roleIds;
  data['postIds'] = entity.postIds;
  data['admin'] = entity.admin;
  return data;
}

extension UserModelExtension on UserModel {
  UserModel copyWith({
    Id? id,
    String? userId,
    String? deptId,
    String? parentId,
    String? roleId,
    String? loginName,
    String? userName,
    String? userType,
    String? email,
    String? phonenumber,
    String? sex,
    String? avatar,
    String? password,
    String? salt,
    String? status,
    String? delFlag,
    String? loginIp,
    String? loginDate,
    String? pwdUpdateDate,
    String? createBy,
    String? createTime,
    String? updateBy,
    String? updateTime,
    String? remark,
    UserModelParams? params,
    String? registrationNo,
    String? individualNo,
    String? deptName,
    String? clientId,
    String? appType,
    UserModelDept? dept,
    List<UserModelRoles>? roles,
    String? roleIds,
    String? postIds,
    bool? admin,
  }) {
    return UserModel()
      ..id = id ?? this.id
      ..userId = userId ?? this.userId
      ..deptId = deptId ?? this.deptId
      ..parentId = parentId ?? this.parentId
      ..roleId = roleId ?? this.roleId
      ..loginName = loginName ?? this.loginName
      ..userName = userName ?? this.userName
      ..userType = userType ?? this.userType
      ..email = email ?? this.email
      ..phonenumber = phonenumber ?? this.phonenumber
      ..sex = sex ?? this.sex
      ..avatar = avatar ?? this.avatar
      ..password = password ?? this.password
      ..salt = salt ?? this.salt
      ..status = status ?? this.status
      ..delFlag = delFlag ?? this.delFlag
      ..loginIp = loginIp ?? this.loginIp
      ..loginDate = loginDate ?? this.loginDate
      ..pwdUpdateDate = pwdUpdateDate ?? this.pwdUpdateDate
      ..createBy = createBy ?? this.createBy
      ..createTime = createTime ?? this.createTime
      ..updateBy = updateBy ?? this.updateBy
      ..updateTime = updateTime ?? this.updateTime
      ..remark = remark ?? this.remark
      ..params = params ?? this.params
      ..registrationNo = registrationNo ?? this.registrationNo
      ..individualNo = individualNo ?? this.individualNo
      ..deptName = deptName ?? this.deptName
      ..clientId = clientId ?? this.clientId
      ..appType = appType ?? this.appType
      ..dept = dept ?? this.dept
      ..roles = roles ?? this.roles
      ..roleIds = roleIds ?? this.roleIds
      ..postIds = postIds ?? this.postIds
      ..admin = admin ?? this.admin;
  }
}

UserModelParams $UserModelParamsFromJson(Map<String, dynamic> json) {
  final UserModelParams userModelParams = UserModelParams();
  return userModelParams;
}

Map<String, dynamic> $UserModelParamsToJson(UserModelParams entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  return data;
}

extension UserModelParamsExtension on UserModelParams {
}

UserModelDept $UserModelDeptFromJson(Map<String, dynamic> json) {
  final UserModelDept userModelDept = UserModelDept();
  final Id? id = jsonConvert.convert<Id>(json['id']);
  if (id != null) {
    userModelDept.id = id;
  }
  final String? searchValue = jsonConvert.convert<String>(json['searchValue']);
  if (searchValue != null) {
    userModelDept.searchValue = searchValue;
  }
  final String? createBy = jsonConvert.convert<String>(json['createBy']);
  if (createBy != null) {
    userModelDept.createBy = createBy;
  }
  final String? createTime = jsonConvert.convert<String>(json['createTime']);
  if (createTime != null) {
    userModelDept.createTime = createTime;
  }
  final String? updateBy = jsonConvert.convert<String>(json['updateBy']);
  if (updateBy != null) {
    userModelDept.updateBy = updateBy;
  }
  final String? updateTime = jsonConvert.convert<String>(json['updateTime']);
  if (updateTime != null) {
    userModelDept.updateTime = updateTime;
  }
  final String? remark = jsonConvert.convert<String>(json['remark']);
  if (remark != null) {
    userModelDept.remark = remark;
  }
  final UserModelDeptParams? params = jsonConvert.convert<UserModelDeptParams>(json['params']);
  if (params != null) {
    userModelDept.params = params;
  }
  final String? registrationNo = jsonConvert.convert<String>(json['registrationNo']);
  if (registrationNo != null) {
    userModelDept.registrationNo = registrationNo;
  }
  final String? individualNo = jsonConvert.convert<String>(json['individualNo']);
  if (individualNo != null) {
    userModelDept.individualNo = individualNo;
  }
  final String? deptName = jsonConvert.convert<String>(json['deptName']);
  if (deptName != null) {
    userModelDept.deptName = deptName;
  }
  final String? deptId = jsonConvert.convert<String>(json['deptId']);
  if (deptId != null) {
    userModelDept.deptId = deptId;
  }
  final String? parentId = jsonConvert.convert<String>(json['parentId']);
  if (parentId != null) {
    userModelDept.parentId = parentId;
  }
  final String? ancestors = jsonConvert.convert<String>(json['ancestors']);
  if (ancestors != null) {
    userModelDept.ancestors = ancestors;
  }
  final String? orderNum = jsonConvert.convert<String>(json['orderNum']);
  if (orderNum != null) {
    userModelDept.orderNum = orderNum;
  }
  final String? leader = jsonConvert.convert<String>(json['leader']);
  if (leader != null) {
    userModelDept.leader = leader;
  }
  final String? phone = jsonConvert.convert<String>(json['phone']);
  if (phone != null) {
    userModelDept.phone = phone;
  }
  final String? email = jsonConvert.convert<String>(json['email']);
  if (email != null) {
    userModelDept.email = email;
  }
  final String? status = jsonConvert.convert<String>(json['status']);
  if (status != null) {
    userModelDept.status = status;
  }
  final String? delFlag = jsonConvert.convert<String>(json['delFlag']);
  if (delFlag != null) {
    userModelDept.delFlag = delFlag;
  }
  final String? parentName = jsonConvert.convert<String>(json['parentName']);
  if (parentName != null) {
    userModelDept.parentName = parentName;
  }
  return userModelDept;
}

Map<String, dynamic> $UserModelDeptToJson(UserModelDept entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['id'] = entity.id;
  data['searchValue'] = entity.searchValue;
  data['createBy'] = entity.createBy;
  data['createTime'] = entity.createTime;
  data['updateBy'] = entity.updateBy;
  data['updateTime'] = entity.updateTime;
  data['remark'] = entity.remark;
  data['params'] = entity.params?.toJson();
  data['registrationNo'] = entity.registrationNo;
  data['individualNo'] = entity.individualNo;
  data['deptName'] = entity.deptName;
  data['deptId'] = entity.deptId;
  data['parentId'] = entity.parentId;
  data['ancestors'] = entity.ancestors;
  data['orderNum'] = entity.orderNum;
  data['leader'] = entity.leader;
  data['phone'] = entity.phone;
  data['email'] = entity.email;
  data['status'] = entity.status;
  data['delFlag'] = entity.delFlag;
  data['parentName'] = entity.parentName;
  return data;
}

extension UserModelDeptExtension on UserModelDept {
  UserModelDept copyWith({
    Id? id,
    String? searchValue,
    String? createBy,
    String? createTime,
    String? updateBy,
    String? updateTime,
    String? remark,
    UserModelDeptParams? params,
    String? registrationNo,
    String? individualNo,
    String? deptName,
    String? deptId,
    String? parentId,
    String? ancestors,
    String? orderNum,
    String? leader,
    String? phone,
    String? email,
    String? status,
    String? delFlag,
    String? parentName,
  }) {
    return UserModelDept()
      ..id = id ?? this.id
      ..searchValue = searchValue ?? this.searchValue
      ..createBy = createBy ?? this.createBy
      ..createTime = createTime ?? this.createTime
      ..updateBy = updateBy ?? this.updateBy
      ..updateTime = updateTime ?? this.updateTime
      ..remark = remark ?? this.remark
      ..params = params ?? this.params
      ..registrationNo = registrationNo ?? this.registrationNo
      ..individualNo = individualNo ?? this.individualNo
      ..deptName = deptName ?? this.deptName
      ..deptId = deptId ?? this.deptId
      ..parentId = parentId ?? this.parentId
      ..ancestors = ancestors ?? this.ancestors
      ..orderNum = orderNum ?? this.orderNum
      ..leader = leader ?? this.leader
      ..phone = phone ?? this.phone
      ..email = email ?? this.email
      ..status = status ?? this.status
      ..delFlag = delFlag ?? this.delFlag
      ..parentName = parentName ?? this.parentName;
  }
}

UserModelDeptParams $UserModelDeptParamsFromJson(Map<String, dynamic> json) {
  final UserModelDeptParams userModelDeptParams = UserModelDeptParams();
  return userModelDeptParams;
}

Map<String, dynamic> $UserModelDeptParamsToJson(UserModelDeptParams entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  return data;
}

extension UserModelDeptParamsExtension on UserModelDeptParams {
}

UserModelRoles $UserModelRolesFromJson(Map<String, dynamic> json) {
  final UserModelRoles userModelRoles = UserModelRoles();
  final Id? id = jsonConvert.convert<Id>(json['id']);
  if (id != null) {
    userModelRoles.id = id;
  }
  final String? roleId = jsonConvert.convert<String>(json['roleId']);
  if (roleId != null) {
    userModelRoles.roleId = roleId;
  }
  final String? roleName = jsonConvert.convert<String>(json['roleName']);
  if (roleName != null) {
    userModelRoles.roleName = roleName;
  }
  final String? roleKey = jsonConvert.convert<String>(json['roleKey']);
  if (roleKey != null) {
    userModelRoles.roleKey = roleKey;
  }
  final String? roleSort = jsonConvert.convert<String>(json['roleSort']);
  if (roleSort != null) {
    userModelRoles.roleSort = roleSort;
  }
  final String? dataScope = jsonConvert.convert<String>(json['dataScope']);
  if (dataScope != null) {
    userModelRoles.dataScope = dataScope;
  }
  final String? status = jsonConvert.convert<String>(json['status']);
  if (status != null) {
    userModelRoles.status = status;
  }
  final String? delFlag = jsonConvert.convert<String>(json['delFlag']);
  if (delFlag != null) {
    userModelRoles.delFlag = delFlag;
  }
  final bool? flag = jsonConvert.convert<bool>(json['flag']);
  if (flag != null) {
    userModelRoles.flag = flag;
  }
  final String? searchValue = jsonConvert.convert<String>(json['searchValue']);
  if (searchValue != null) {
    userModelRoles.searchValue = searchValue;
  }
  final String? createBy = jsonConvert.convert<String>(json['createBy']);
  if (createBy != null) {
    userModelRoles.createBy = createBy;
  }
  final String? createTime = jsonConvert.convert<String>(json['createTime']);
  if (createTime != null) {
    userModelRoles.createTime = createTime;
  }
  final String? updateBy = jsonConvert.convert<String>(json['updateBy']);
  if (updateBy != null) {
    userModelRoles.updateBy = updateBy;
  }
  final String? updateTime = jsonConvert.convert<String>(json['updateTime']);
  if (updateTime != null) {
    userModelRoles.updateTime = updateTime;
  }
  final String? remark = jsonConvert.convert<String>(json['remark']);
  if (remark != null) {
    userModelRoles.remark = remark;
  }
  final UserModelRolesParams? params = jsonConvert.convert<UserModelRolesParams>(json['params']);
  if (params != null) {
    userModelRoles.params = params;
  }
  final String? registrationNo = jsonConvert.convert<String>(json['registrationNo']);
  if (registrationNo != null) {
    userModelRoles.registrationNo = registrationNo;
  }
  final String? individualNo = jsonConvert.convert<String>(json['individualNo']);
  if (individualNo != null) {
    userModelRoles.individualNo = individualNo;
  }
  final String? deptName = jsonConvert.convert<String>(json['deptName']);
  if (deptName != null) {
    userModelRoles.deptName = deptName;
  }
  final String? menuIds = jsonConvert.convert<String>(json['menuIds']);
  if (menuIds != null) {
    userModelRoles.menuIds = menuIds;
  }
  final String? deptIds = jsonConvert.convert<String>(json['deptIds']);
  if (deptIds != null) {
    userModelRoles.deptIds = deptIds;
  }
  final bool? admin = jsonConvert.convert<bool>(json['admin']);
  if (admin != null) {
    userModelRoles.admin = admin;
  }
  return userModelRoles;
}

Map<String, dynamic> $UserModelRolesToJson(UserModelRoles entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  data['id'] = entity.id;
  data['roleId'] = entity.roleId;
  data['roleName'] = entity.roleName;
  data['roleKey'] = entity.roleKey;
  data['roleSort'] = entity.roleSort;
  data['dataScope'] = entity.dataScope;
  data['status'] = entity.status;
  data['delFlag'] = entity.delFlag;
  data['flag'] = entity.flag;
  data['searchValue'] = entity.searchValue;
  data['createBy'] = entity.createBy;
  data['createTime'] = entity.createTime;
  data['updateBy'] = entity.updateBy;
  data['updateTime'] = entity.updateTime;
  data['remark'] = entity.remark;
  data['params'] = entity.params?.toJson();
  data['registrationNo'] = entity.registrationNo;
  data['individualNo'] = entity.individualNo;
  data['deptName'] = entity.deptName;
  data['menuIds'] = entity.menuIds;
  data['deptIds'] = entity.deptIds;
  data['admin'] = entity.admin;
  return data;
}

extension UserModelRolesExtension on UserModelRoles {
  UserModelRoles copyWith({
    Id? id,
    String? roleId,
    String? roleName,
    String? roleKey,
    String? roleSort,
    String? dataScope,
    String? status,
    String? delFlag,
    bool? flag,
    String? searchValue,
    String? createBy,
    String? createTime,
    String? updateBy,
    String? updateTime,
    String? remark,
    UserModelRolesParams? params,
    String? registrationNo,
    String? individualNo,
    String? deptName,
    String? menuIds,
    String? deptIds,
    bool? admin,
  }) {
    return UserModelRoles()
      ..id = id ?? this.id
      ..roleId = roleId ?? this.roleId
      ..roleName = roleName ?? this.roleName
      ..roleKey = roleKey ?? this.roleKey
      ..roleSort = roleSort ?? this.roleSort
      ..dataScope = dataScope ?? this.dataScope
      ..status = status ?? this.status
      ..delFlag = delFlag ?? this.delFlag
      ..flag = flag ?? this.flag
      ..searchValue = searchValue ?? this.searchValue
      ..createBy = createBy ?? this.createBy
      ..createTime = createTime ?? this.createTime
      ..updateBy = updateBy ?? this.updateBy
      ..updateTime = updateTime ?? this.updateTime
      ..remark = remark ?? this.remark
      ..params = params ?? this.params
      ..registrationNo = registrationNo ?? this.registrationNo
      ..individualNo = individualNo ?? this.individualNo
      ..deptName = deptName ?? this.deptName
      ..menuIds = menuIds ?? this.menuIds
      ..deptIds = deptIds ?? this.deptIds
      ..admin = admin ?? this.admin;
  }
}

UserModelRolesParams $UserModelRolesParamsFromJson(Map<String, dynamic> json) {
  final UserModelRolesParams userModelRolesParams = UserModelRolesParams();
  return userModelRolesParams;
}

Map<String, dynamic> $UserModelRolesParamsToJson(UserModelRolesParams entity) {
  final Map<String, dynamic> data = <String, dynamic>{};
  return data;
}

extension UserModelRolesParamsExtension on UserModelRolesParams {
}