import 'package:anchor_collect_flutter/congifs.dart';
import 'package:anchor_collect_flutter/pages/login/login_view.dart';
import 'package:anchor_collect_flutter/routes/pages.dart';
import 'package:anchor_collect_flutter/routes/routes.dart';
import 'package:anchor_collect_flutter/utils/sp_helper.dart';
import 'package:anchor_collect_flutter/utils/storage_utils.dart';
import 'package:camera/camera.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:flutter_smart_dialog/flutter_smart_dialog.dart';
import 'package:get/get.dart';

import 'controllers/global_service.dart';

final mDialog = FlutterSmartDialog.init();
final easyload = EasyLoading.init();

Future<void> main() async {
  await initServices();
  await SpHelper.init();
  await StorageUtils.init();
  await initCamera();

  runApp(GetMaterialApp(
    getPages: AppPages.pages,
    initialRoute: AppRoute.LOGIN,
    builder: (context, child) {
      child = easyload(context, child);
      child = mDialog(context, child);
      return child;
    },
  ));
}

/// 在你运行Flutter应用之前，让你的服务初始化是一个明智之举。
////因为你可以控制执行流程（也许你需要加载一些主题配置，apiKey，由用户自定义的语言等，所以在运行ApiService之前加载SettingService。
///所以GetMaterialApp()不需要重建，可以直接取值。
Future<void> initServices() async {
  print('starting services ...');

  ///这里是你放get_storage、hive、shared_pref初始化的地方。
  ///或者moor连接，或者其他什么异步的东西。
  await Get.putAsync(() => GlobalService().init());

  print('All services started...');
}

Future<void> initCamera() async {
  // 获取可用的相机列表
  Config.cameras = await availableCameras();

}
