import 'package:anchor_collect_flutter/generated/json/base/json_field.dart';
import 'dart:convert';

import 'package:isar/isar.dart';

import '../generated/json/cattle_resume_entity.g.dart';

part 'cattle_resume_entity.g.dart';

@JsonSerializable()
@collection
class CattleResumeEntity {
  Id id = Isar.autoIncrement;

  /** unid主键 */
  @Index(unique: true, replace: true)
  String? unid;

  /** 电子耳标 */
  String? registrationNo;

  /** 可视耳标 */
  String? individualNo;

  /** 圈舍号 */
  String? circleNo;

  /** 饲养类型;（牛，羊，马） */
  String? raiseType;

  /** 饲养品种;（利木赞，西门塔尔等） */
  String? raiseVarieties;

  /** 出生日期 */
  String? birthdate;

  /** 出生重量 */
  double? birthHeavy;

  /** 性别 */
  String? sex;

  /** 出生难易度 */
  String? birthDifficulty;

  /** 是否双胎 */
  String? isTwins;

  /** 母本胎次 */
  String? childTime;

  /** 等级 */
  String? grade;

  /** 父登记号 */
  String? fatherReg;

  /** 母登记号 */
  String? motherReg;

  /** 离乳重 */
  double? fromMilkHeavy;

  /** 健康状态 */
  String? health;

  /** 6月龄重 */
  String? junHeavy;

  /** 12月外貌评分 */
  String? decAppScore;

  /** 照片路径;(可以多图片“，”分割) */
  String? photo;

  /** 照片路径, 手持机用*/
  String? photoPath;

  /** 状态（育种，育成，成年;淘汰，出售） */
  String? status;

  /** 是否淘汰;0,在用，1淘汰 */
  int? isOut;

  /**
   * 母牛年龄
   */
  int? age;

  /** 犊牛毛色 */
  String? colour;

  /** 时间戳 */
  String? inputTime;

  /** 部门id */
  String? deptId;

  /** 是否上传 0未上传，1已上传 */
  String? uploadStatus;

  /** 更新时间 */
  String? uploadTime;

  /** 创建者 */
  String? createBy;

  /** 创建时间 */
  String? createTime;

  /** 更新者 */
  String? updateBy;

  /** 更新时间 */
  String? updateTime;

  /** 备注 */
  String? remark;

  CattleResumeEntity();

  factory CattleResumeEntity.fromJson(Map<String, dynamic> json) =>
      $CattleResumeEntityFromJson(json);

  Map<String, dynamic> toJson() => $CattleResumeEntityToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}
