import 'package:anchor_collect_flutter/generated/json/base/json_field.dart';
import 'dart:convert';

import 'package:isar/isar.dart';

import '../generated/json/dict_entity.g.dart';

part 'dict_entity.g.dart';

@JsonSerializable()
@collection
class DictEntity {
  Id id = Isar.autoIncrement;

  /** 字典编码 */
  @Index(unique: true, replace: true)
  String? dictCode;

  /** 字典排序 */
  String? dictSort;

  /** 字典标签 */
  String? dictLabel;

  /** 字典键值 */
  String? dictValue;

  /** 字典类型 */
  String? dictType;

  /** 样式属性（其他样式扩展） */
  String? cssClass;

  /** 表格字典样式 */
  String? listClass;

  /** 是否默认（Y是 N否） */
  String? isDefault;

  /** 状态（0正常 1停用） */
  String? status;

  /** 创建者 */
  String? createBy;

  /** 创建时间 */
  String? createTime;

  /** 更新者 */
  String? updateBy;

  /** 更新时间 */
  String? updateTime;

  /** 备注 */
  String? remark;
  String? deptName;

  DictEntity();

  factory DictEntity.fromJson(Map<String, dynamic> json) =>
      $DictEntityFromJson(json);

  Map<String, dynamic> toJson() => $DictEntityToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}
