import 'dart:convert';
import 'dart:ffi';

import 'package:anchor_collect_flutter/generated/json/base/json_field.dart';

import 'package:isar/isar.dart';

import '../generated/json/base/json_convert_content.dart';
import '../generated/json/user_model.g.dart';

part 'user_model.g.dart';

@JsonSerializable()
@collection
class UserModel {
  Id id = Isar.autoIncrement;

  /** 用户ID */
  @Index(unique: true, replace: true)
  String? userId;

  /** 部门ID */
  String? deptId;

  /** 部门父ID */
  String? parentId;

  /** 角色ID */
  String? roleId;

  /** 登录名称 */
  String? loginName;

  /** 用户名称 */
  String? userName;

  /** 用户类型 */
  String? userType;

  /** 用户邮箱 */
  String? email;

  /** 手机号码 */
  String? phonenumber;

  /** 用户性别 */
  String? sex;

  /** 用户头像 */
  String? avatar;

  /** 密码 */
  String? password;

  /** 盐加密 */
  String? salt;

  /** 帐号状态（0正常 1停用） */
  String? status;

  /** 删除标志（0代表存在 2代表删除） */
  String? delFlag;

  /** 最后登录IP */
  String? loginIp;

  /** 最后登录时间 */
  String? loginDate;

  /** 密码最后更新时间 */
  String? pwdUpdateDate;

  String? createBy;
  String? createTime;
  String? updateBy;
  String? updateTime;
  String? remark;
  @ignore
  UserModelParams? params;
  String? registrationNo;
  String? individualNo;
  String? deptName;
  String? clientId;
  String? appType;

  /** 部门对象 */
  @ignore
  UserModelDept? dept;
  @ignore
  List<UserModelRoles>? roles;
  String? roleIds;
  String? postIds;
  bool? admin;

  UserModel();

  factory UserModel.fromJson(Map<String, dynamic> json) =>
      $UserModelFromJson(json);

  Map<String, dynamic> toJson() => $UserModelToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}

@JsonSerializable()
class UserModelParams {
  UserModelParams();

  factory UserModelParams.fromJson(Map<String, dynamic> json) =>
      $UserModelParamsFromJson(json);

  Map<String, dynamic> toJson() => $UserModelParamsToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}

@JsonSerializable()
@collection
class UserModelDept {
  Id id = Isar.autoIncrement;
  String? searchValue;
  String? createBy;
  String? createTime;
  String? updateBy;
  String? updateTime;
  String? remark;
  @ignore
  UserModelDeptParams? params;
  String? registrationNo;
  String? individualNo;
  String? deptName;
  @Index(unique: true, replace: true)
  String? deptId;
  String? parentId;
  String? ancestors;
  String? orderNum;
  String? leader;
  String? phone;
  String? email;
  String? status;
  String? delFlag;
  String? parentName;

  UserModelDept();

  factory UserModelDept.fromJson(Map<String, dynamic> json) =>
      $UserModelDeptFromJson(json);

  Map<String, dynamic> toJson() => $UserModelDeptToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}

@JsonSerializable()
class UserModelDeptParams {
  UserModelDeptParams();

  factory UserModelDeptParams.fromJson(Map<String, dynamic> json) =>
      $UserModelDeptParamsFromJson(json);

  Map<String, dynamic> toJson() => $UserModelDeptParamsToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}

@JsonSerializable()
@collection
class UserModelRoles {
  Id id = Isar.autoIncrement;

  /**
   * 角色ID
   */
  @Index(unique: true, replace: true)
  String? roleId;

  /**
   * 角色名称
   */
  String? roleName;

  /**
   * 角色权限
   */
  String? roleKey;

  /**
   * 角色排序
   */
  String? roleSort;

  /**
   * 数据范围（1：所有数据权限；2：自定义数据权限；3：本部门数据权限；4：本部门及以下数据权限；5：仅本人数据权限）
   */
  String? dataScope;

  /**
   * 角色状态（0正常 1停用）
   */
  String? status;

  /**
   * 删除标志（0代表存在 2代表删除）
   */
  String? delFlag;

  /**
   * 用户是否存在此角色标识 默认不存在
   */
  bool? flag = false;
  String? searchValue;
  String? createBy;
  String? createTime;
  String? updateBy;
  String? updateTime;
  String? remark;
  @ignore
  UserModelRolesParams? params;
  String? registrationNo;
  String? individualNo;
  String? deptName;
  String? menuIds;
  String? deptIds;
  bool? admin;

  UserModelRoles();

  factory UserModelRoles.fromJson(Map<String, dynamic> json) =>
      $UserModelRolesFromJson(json);

  Map<String, dynamic> toJson() => $UserModelRolesToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}

@JsonSerializable()
class UserModelRolesParams {
  UserModelRolesParams();

  factory UserModelRolesParams.fromJson(Map<String, dynamic> json) =>
      $UserModelRolesParamsFromJson(json);

  Map<String, dynamic> toJson() => $UserModelRolesParamsToJson(this);

  @override
  String toString() {
    return jsonEncode(this);
  }
}
