import 'dart:io';

import 'package:anchor_collect_flutter/congifs.dart';
import 'package:anchor_collect_flutter/utils/dialog_utils.dart';
import 'package:camera/camera.dart';
import 'package:flutter/foundation.dart';
import 'package:get/get.dart';
import 'package:permission_handler/permission_handler.dart';

import '../../utils/compress_util.dart';
import 'camera_state.dart';

class CameraLogic extends GetxController {
  final CameraState state = CameraState();

  // 请求相机权限
  Future<void> _askCameraPermission() async {
    var status = await Permission.camera.status;
    if (!status.isGranted) {
      PermissionStatus status = await Permission.camera.request();
      if (status.isDenied) {
        // 用户拒绝了权限，请相应处理。
      }
      if (status.isRestricted) {
        // 由于某些限制，用户不能授予权限，请相应处理。
      }
    }
  }

  // 捕获图片
  Future<void> capturePicture() async {
    await _askCameraPermission();
    XFile? selectedImage = await Config.controller.takePicture();
    if(!selectedImage.isNull) {
          Get.back(result: selectedImage!.path);
        }else{
          DialogUtils.showWarningDialog('拍照失败');
        }

    // if (!selectedImage.isNull) {
    //   XFile? compressFile = await CompressUtil.compressXFileWithXFile(selectedImage, state.curUnid);
    //   if(!compressFile.isNull) {
    //     Get.back(result: compressFile!.path);
    //   }else{
    //     DialogUtils.showWarningDialog('拍照压缩失败');
    //   }
    // }
  }

  @override
  void onReady() {
    var unid = Get.arguments ;

    if(unid!=null){
      state.curUnid = unid ;
      if (kDebugMode) {
        print('why:onReady:${state.curUnid}');
      }
    }
  }

  @override
  void onInit() {
    super.onInit();

  }

  @override
  void dispose() {
    super.dispose();
  }
}
