import 'package:camera/camera.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../congifs.dart';
import 'camera_logic.dart';

class CameraPage extends StatelessWidget {
    final logic = Get.find<CameraLogic>();
    final state = Get.find<CameraLogic>().state;
   CameraPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {

    if(!Config.controller.value.isInitialized){
      return Container();
    }

    return Scaffold(
      appBar: AppBar(title: const Text('牛只拍照')),


    body: Column(
        children: <Widget>[
          Expanded(
            child: AspectRatio(
              aspectRatio: Config.controller.value.aspectRatio,
              child: CameraPreview(Config.controller), // 显示相机预览
            ),
          ),
          ListTile(
            leading: const Icon(Icons.camera),
            title: const Text('拍照'),
            onTap: logic.capturePicture, // 点击后捕获图片
          ),
        ],
      ),
    );
  }
}
