import 'package:anchor_collect_flutter/models/cattle_resume_entity.dart';
import 'package:anchor_collect_flutter/routes/routes.dart';
import 'package:anchor_collect_flutter/utils/empty_utils.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:isar/isar.dart';

import '../../../controllers/global_service.dart';
import '../../../utils/dict_utils.dart';
import 'cattle_resume_list_state.dart';

class CattleResumeListLogic extends GetxController {
  final CattleResumeListState state = CattleResumeListState();

  bool isShow = false;

  queryByFilter() async {

    state.dataList.clear();
    if(EmptyUtils.isStrNotEmpty(state.filterHighNo)&&EmptyUtils.isStrNotEmpty(state.filterVisualNo)&&
        EmptyUtils.isStrNotEmpty(state.filterFatherNo)&&EmptyUtils.isStrNotEmpty(state.filterMotherNo)){
      state.dataList = await GlobalService.to.isar.cattleResumeEntitys.filter().unidIsNotEmpty().findAll();
    }else {
      state.dataList = await GlobalService.to.isar.cattleResumeEntitys
          .filter()
          .optional(EmptyUtils.isStrNotEmpty(state.filterHighNo), (q) => q.registrationNoEqualTo(state.filterHighNo))
          .optional(EmptyUtils.isStrNotEmpty(state.filterVisualNo), (q) => q.individualNoEqualTo(state.filterVisualNo))
          .optional(EmptyUtils.isStrNotEmpty(state.filterFatherNo), (q) => q.fatherRegEqualTo(state.filterFatherNo))
          .optional(EmptyUtils.isStrNotEmpty(state.filterMotherNo), (q) => q.motherRegEqualTo(state.filterMotherNo))
          .findAll();
    }
    isShow= false;
    getItemList(state.dataList);
  }

  queryAll() async {
    state.dataList = await GlobalService.to.isar.cattleResumeEntitys.filter().unidIsNotEmpty().findAll();
    getItemList(state.dataList);
  }

  clean() {
    state.filterHighNo = '';
    state.filterVisualNo = '';
    state.filterFatherNo = '';
    state.filterMotherNo = '';
    update();
  }

  getItemList(List<CattleResumeEntity> itemDateList) async {
    List<Widget> list = [];

    if (kDebugMode) {
      print('基础信息数量：${itemDateList.length}');
    }
    for (int i = 0; i < itemDateList.length; i++) {
      list.add(Padding(
        padding: const EdgeInsets.all(15.0),
        child: InkWell(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.stretch,
            children: [
              getCattleResumeItem('电子耳标', itemDateList[i].registrationNo),
              const SizedBox(
                height: 5,
              ),
              getCattleResumeItem('可视耳标', itemDateList[i].individualNo),
              const SizedBox(
                height: 5,
              ),
              getCattleResumeItem(
                  '圈舍号', await DictUtils.getDictName('zxgl_circle_list', itemDateList[i].circleNo ?? '')),
              const SizedBox(
                height: 5,
              ),
              getCattleResumeItem('饲养品种',
                  await DictUtils.getDictName('zxgl_cattle_raiseVarieties', itemDateList[i].raiseVarieties ?? '')),
              const SizedBox(
                height: 5,
              ),
              getCattleResumeItem(
                  '状态', await DictUtils.getDictName('zxgl_cattleresume_status', itemDateList[i].status ?? '')),
            ],
          ),
          onTap: () => itemOnClickListener(entity: itemDateList[i]),
        ),
      ));
    }

    state.items = list;
    update();
  }

  getCattleResumeItem(String title, String? context) {
    print('why:$title:$context');
    return Row(
      children: [
        Text(
          title,
          style: const TextStyle(
            color: Colors.black,
            fontSize: 15,
          ),
        ),
        const Expanded(
          child: SizedBox(
            height: 1,
          ),
        ),
        Text(
          context ?? '',
          style: const TextStyle(
            color: Colors.black45,
            fontSize: 15,
          ),
        ),
      ],
    );
  }

  void itemOnClickListener({CattleResumeEntity? entity}) {
    Get.toNamed(AppRoute.CATTLE_RESUME, arguments: entity);
  }
}
