import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'cattle_resume_list_logic.dart';

class CattleResumeListPage extends StatelessWidget {
  CattleResumeListPage({Key? key}) : super(key: key);
  final logic = Get.find<CattleResumeListLogic>();
  final state = Get
      .find<CattleResumeListLogic>()
      .state;

  @override
  Widget build(BuildContext context) {
    logic.queryAll();
    return Scaffold(
      appBar: AppBar(
        title: const Text('基础信息列表'),
        centerTitle: true,
        actions: [
          Padding(
            padding: const EdgeInsets.all(5.0),
            child: InkWell(
              child: const Icon(Icons.search),
              onTap: () {
                logic.clean();
                logic.isShow = !logic.isShow;
                logic.update();
              },
            ),
          ),
          Padding(
            padding: const EdgeInsets.all(5.0),
            child: InkWell(
              child: const Center(
                child: Text('新增'),
              ),
              onTap: () => logic.itemOnClickListener(),
            ),
          ),
        ],
      ),
      body: GetBuilder<CattleResumeListLogic>(builder: (logic) {
        return Center(
          child: Stack(children: [
            ListView.separated(
              itemCount: state.items.length,
              itemBuilder: (context, index) {
                return state.items[index];
              },
              separatorBuilder: (context, index) {
                return Container(
                  height: 3,
                  color: Colors.black12,
                );
              },
            ),
            logic.isShow
                ? Row(
              children: [
                Expanded(
                  child: InkWell(
                    child: Container(
                      height: double.infinity,
                      color: Colors.black26,
                    ),
                    onTap: () =>
                    {
                      logic.isShow = false,
                      logic.update(),
                    },
                  ),
                ),
                GetBuilder<CattleResumeListLogic>(builder: (logic) {
                  return Container(
                    width: 280,
                    color: Colors.white,
                    padding: const EdgeInsets.all(20),
                    child: Column(
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        TextField(
                          onChanged: (text) {
                            state.filterHighNo = text;
                          },
                          decoration: const InputDecoration(
                            prefixIcon: Icon(Icons.search),
                            border: OutlineInputBorder(),
                            hintText: '电子耳标',
                            contentPadding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 8.0),
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        TextField(
                          onChanged: (text) {
                            state.filterVisualNo = text;
                          },
                          decoration: const InputDecoration(
                            prefixIcon: Icon(Icons.search),
                            border: OutlineInputBorder(),
                            hintText: '可视耳标',
                            contentPadding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 8.0),
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        TextField(
                          onChanged: (text) {
                            state.filterFatherNo = text;
                          },
                          decoration: const InputDecoration(
                            prefixIcon: Icon(Icons.search),
                            border: OutlineInputBorder(),
                            hintText: '父登记号',
                            contentPadding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 8.0),
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        TextField(
                          onChanged: (text) {
                            state.filterMotherNo = text;
                          },
                          decoration: const InputDecoration(
                            prefixIcon: Icon(Icons.search),
                            border: OutlineInputBorder(),
                            hintText: '母登记号',
                            contentPadding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 8.0),
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        SizedBox(
                          width: Get.width,
                          child: TextButton(
                            style: ButtonStyle(
                              backgroundColor: MaterialStateProperty.all(Colors.blue),
                              foregroundColor: MaterialStateProperty.all(Colors.white),
                              padding: MaterialStateProperty.all(const EdgeInsets.all(10)),
                            ),
                            onPressed: () =>
                            {
                              logic.queryByFilter(),
                            },
                            child: const Text("查询"),
                          ),
                        ),
                        const SizedBox(
                          height: 10,
                        ),
                        SizedBox(
                          width: Get.width,
                          child: TextButton(
                            style: ButtonStyle(
                              backgroundColor: MaterialStateProperty.all(Colors.white),
                              foregroundColor: MaterialStateProperty.all(Colors.blue),
                              padding: MaterialStateProperty.all(const EdgeInsets.all(10)),
                              shape: MaterialStateProperty.all<RoundedRectangleBorder>(
                                RoundedRectangleBorder(
                                  borderRadius: BorderRadius.circular(10),
                                ),
                              ),
                              side: MaterialStateProperty.all<BorderSide>(const BorderSide(
                                color: Colors.black54, // 边框颜色
                                width: 1, // 边框宽度
                              )),
                            ),
                            onPressed: () => logic.clean(),
                            child: const Text("重置"),
                          ),
                        ),
                      ],
                    ),
                  );
                }),
              ],
            )
                : Container(),
          ]),
        );
      }),
    );
  }
}
