import 'dart:io';

import 'package:anchor_collect_flutter/utils/dialog_utils.dart';
import 'package:anchor_collect_flutter/utils/dict_utils.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../congifs.dart';
import '../../routes/routes.dart';
import '../../utils/empty_utils.dart';
import 'cattle_resume_logic.dart';
import 'package:flutter_speed_dial/flutter_speed_dial.dart';

class CattleResumePage extends StatelessWidget {
  CattleResumePage({Key? key}) : super(key: key);
  final logic = Get.find<CattleResumeLogic>();
  final state = Get.find<CattleResumeLogic>().state;

  @override
  Widget build(BuildContext context) {
    state.isCamera = false;
    return Scaffold(
      appBar: AppBar(
        title: const Text('基础信息'),
        centerTitle: true,
      ),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.stretch,
        children: <Widget>[
          Expanded(
            child: GetBuilder<CattleResumeLogic>(builder: (logic) {
              return ListView(
                children: [
                  ///图片
                  InkWell(
                    child: AspectRatio(
                      aspectRatio: 1.0 / 1.0,
                      child: Image.file(
                        File(state.photoPath ?? ''),
                        fit: BoxFit.contain,
                      ),
                    ),
                    onTap: () async {
                      var photoPath = await Get.toNamed(AppRoute.CAMERA, arguments: state.unid);
                      if (EmptyUtils.isStrNotEmpty(photoPath)) {
                        state.isCamera = true;
                        state.photoPath = photoPath;
                        logic.update();
                      }
                    },
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView('高频耳标', state.entity.registrationNo ?? '', () => {}),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '可视耳标',
                          state.entity.individualNo ?? '',
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '请输入可视耳标',
                                    onPositive: (text) => {
                                          state.entity.individualNo = text,
                                          logic.update(),
                                        })
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '出生重量',
                          (state.entity.birthHeavy ?? '').toString(),
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入出生重量(kg)',
                                    onPositive: (text) => {
                                          state.entity.birthHeavy = double.parse(text),
                                          logic.update(),
                                        }),
                              }),
                      getItemView('出生日期', state.entity.birthdate ?? '', () => {
                        DialogUtils.showTimeDialog(
                            context,
                          isTime:true,
                          title: '请选择出生日期',
                          onPositive: (date)=>{
                            state.entity.birthdate= date,
                            logic.update(),
                          },
                        ),
                      }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '饲养类型',
                          state.raiseType ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(await DictUtils.getDictList('zxgl_raiseType'),
                                    onPositive: (selectReslut) => {
                                          state.raiseType = selectReslut.key,
                                          state.entity.raiseType = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '饲养品种',
                          state.raiseVarieties ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(
                                    await DictUtils.getDictList('zxgl_cattle_raiseVarieties'),
                                    onPositive: (selectReslut) => {
                                          state.raiseVarieties = selectReslut.key,
                                          state.entity.raiseVarieties = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '性别',
                          state.sex ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(await DictUtils.getDictList('zxgl_cattleresume_sex'),
                                    onPositive: (selectReslut) => {
                                          state.sex = selectReslut.key,
                                          state.entity.sex = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '出生难易度',
                          state.birthDifficulty ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(
                                    await DictUtils.getDictList('zxgl_cattleresume_birthDifficulty'),
                                    onPositive: (selectReslut) => {
                                          state.birthDifficulty = selectReslut.key,
                                          state.entity.birthDifficulty = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '犊牛毛色',
                          state.entity.colour ?? '',
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入犊牛毛色',
                                    onPositive: (text) => {
                                          state.entity.colour = text,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '是否双胞胎',
                          state.isTwins ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(await DictUtils.getDictList('sys_yes_no'),
                                    onPositive: (selectReslut) => {
                                          state.isTwins = selectReslut.key,
                                          state.entity.isTwins = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '母本胎次',
                          state.entity.childTime ?? '',
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入母本胎次',
                                    onPositive: (text) => {
                                          state.entity.childTime = text,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '父登记号',
                          state.entity.fatherReg ?? '',
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入父登记号',
                                    onPositive: (text) => {
                                          state.entity.fatherReg = text,
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '母登记号',
                          state.entity.motherReg ?? '',
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入母登记号',
                                    onPositive: (text) => {
                                          state.entity.motherReg = text,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '母牛年龄',
                          (state.entity.age ?? '0').toString(),
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入母牛年龄',
                                    onPositive: (text) => {
                                          state.entity.age = int.parse(text),
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '圈舍号',
                          state.circleNo ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(await DictUtils.getDictList('zxgl_circle_list'),
                                    onPositive: (selectReslut) => {
                                          state.circleNo = selectReslut.key,
                                          state.entity.circleNo = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '健康状态',
                          state.health ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(
                                    await DictUtils.getDictList('zxgl_cattleresume_health'),
                                    onPositive: (selectReslut) => {
                                          state.health = selectReslut.key,
                                          state.entity.health = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                  Row(
                    children: [
                      const SizedBox(
                        width: 10,
                      ),
                      getItemView(
                          '状态',
                          state.status ?? '',
                          () async => {
                                DialogUtils.showSingleListDialog(
                                    await DictUtils.getDictList('zxgl_cattleresume_status'),
                                    onPositive: (selectReslut) => {
                                          state.status = selectReslut.key,
                                          state.entity.status = selectReslut.value,
                                          logic.update(),
                                        }),
                              }),
                      getItemView(
                          '备注',
                          state.entity.remark ?? '',
                          () => {
                                DialogUtils.showInputDialog(
                                    hintText: '输入备注',
                                    onPositive: (text) => {
                                          state.entity.remark = text,
                                          logic.update(),
                                        }),
                              }),
                      const SizedBox(
                        width: 10,
                      ),
                    ],
                  ),
                ],
              );
            }),
          ),
          // Row(children: [
          //   Expanded(
          //     child:
          TextButton(
            style: ButtonStyle(
              backgroundColor: MaterialStateProperty.all(Colors.blue),
              foregroundColor: MaterialStateProperty.all(Colors.white),
              padding: MaterialStateProperty.all(EdgeInsets.all(10)),
            ),
            onPressed: () => {
              logic.save(),
            },
            child: const Text("保存"),
          ),
          //   ),
          // ]),
        ],
      ),
      floatingActionButtonLocation: FloatingActionButtonLocation.endFloat,
      floatingActionButton: SpeedDial(
        icon: Icons.add,
        activeIcon: Icons.close,
        spacing: 3,
        // openCloseDial: ValueNotifier.value,
        childPadding: const EdgeInsets.all(5),
        buttonSize: const Size(40, 40),
        elevation: 8.0,
        children: [
          SpeedDialChild(
            child: const Icon(IconFont.cattle_resume),
            backgroundColor: Colors.black,
            foregroundColor: Colors.white,
            label: '基础信息',
            onTap: () {
              DialogUtils.showToast('toast...');
            },
            onLongPress: () => debugPrint('FIRST CHILD LONG PRESS'),
          ),
          SpeedDialChild(
            child: const Icon(IconFont.performance),
            backgroundColor: const Color.fromARGB(255, 104, 152, 218),
            foregroundColor: Colors.white,
            label: '性能测定',
            onTap: () => {
              DialogUtils.showLoadingDialog('加载中...'),
            },
          ),
          SpeedDialChild(
            child: const Icon(IconFont.medical_record),
            backgroundColor: const Color.fromARGB(255, 220, 128, 70),
            foregroundColor: Colors.white,
            label: '诊疗记录',
            visible: true,
            onTap: () => DialogUtils.showInputDialog(onPositive: (inputStr) {
              ScaffoldMessenger.of(context).showSnackBar(SnackBar(content: Text(inputStr)));
            }),
            onLongPress: () => debugPrint('THIRD CHILD LONG PRESS'),
          ),
          SpeedDialChild(
            child: const Icon(IconFont.breeding_record),
            backgroundColor: const Color.fromARGB(255, 210, 76, 154),
            foregroundColor: Colors.white,
            label: '配种记录',
            onTap: () => {DialogUtils.showWarningDialog('配种记录！！')},
            onLongPress: () => debugPrint('FIRST CHILD LONG PRESS'),
          ),
          SpeedDialChild(
            child: const Icon(IconFont.immune),
            backgroundColor: const Color.fromARGB(255, 116, 154, 110),
            foregroundColor: Colors.white,
            label: '免疫记录',
            onTap: () => {},
          ),
          SpeedDialChild(
            child: const Icon(IconFont.weight),
            backgroundColor: const Color.fromARGB(255, 150, 114, 89),
            foregroundColor: Colors.white,
            label: '称重记录',
            visible: true,
            onTap: () =>
                DialogUtils.showMultipleListDialog(['aaa', 'bbb', 'ccc'], ['111', '222', '333'], onPositive: (result) {
              ScaffoldMessenger.of(context).showSnackBar(SnackBar(content: Text(result)));
            }),
            // onLongPress: () => ,
          ),
        ],
      ),
    );
  }

  getItemView(String title, String context, Function() onClick) {
    return Expanded(
      child: InkWell(
        onTap: onClick,
        child: Container(
          decoration: const BoxDecoration(
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: Colors.black12,
                blurRadius: 2,
              ),
            ],
          ),
          padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              const SizedBox(
                height: 10,
              ),
              Text(
                title,
                style: const TextStyle(
                  color: Colors.blue,
                  fontSize: 14,
                ),
              ),
              const SizedBox(
                height: 10,
              ),
              SizedBox(
                height: 1,
                child: Container(
                  color: Colors.black12,
                  height: 1,
                ),
              ),
              const SizedBox(
                height: 10,
              ),
              Text(
                context,
                style: const TextStyle(
                  color: Colors.black,
                  fontSize: 14,
                ),
              ),
              const SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
