import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../congifs.dart';
import 'home_logic.dart';

class HomePage extends StatelessWidget {
  HomePage({Key? key}) : super(key: key);
  final logic = Get.find<HomeLogic>();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('首页'),
        backgroundColor: Colors.blue,
        centerTitle: true,
        elevation: 10,
        actions: [
          InkWell(
            child: Icon(Icons.settings),
            onTap: () => {},
          ),
        ],
      ),
      body: Scrollbar(
        child: SingleChildScrollView(
          child: Column(
            children: [
              //banner
              Image.asset('images/banner.png'),
              //牛只数量
              Row(
                children: [
                  const SizedBox(
                    width: 8,
                  ),
                  Obx(() {
                    return _getCountItem('images/1.png', '养殖中',
                        logic.breedingCount.value, IconFont.breeding_count);
                  }),
                  const SizedBox(
                    width: 8,
                  ),
                  Obx(() {
                    return _getCountItem('images/2.png', '已淘汰',
                        logic.obsoleteCount.value, IconFont.obsolete_count);
                  }),
                  const SizedBox(
                    width: 8,
                  ),
                ],
              ),
              Row(
                children: [
                  const SizedBox(
                    width: 8,
                  ),
                  Obx(() {
                    return _getCountItem('images/3.png', '已死亡',
                        logic.deadCount.value, IconFont.dead_count);
                  }),
                  const SizedBox(
                    width: 8,
                  ),
                  Obx(() {
                    return _getCountItem(
                      'images/4.png',
                      '已出售',
                      logic.sellCount.value,
                      IconFont.sell_count,
                    );
                  }),
                  const SizedBox(
                    width: 8,
                  ),
                ],
              ),
              const SizedBox(height: 20),

              ///功能按钮
              Row(
                children: [
                  const SizedBox(width: 10),
                  Container(
                    width: 4,
                    height: 12,
                    color: Colors.blue,
                  ),
                  const SizedBox(width: 5),
                  const Text('功能模块'),
                ],
              ),
              const SizedBox(height: 20),
              Row(
                children: [
                  const SizedBox(
                    width: 8,
                  ),
                  _getFunButton('基础信息', IconFont.cattle_resume, Colors.black),
                  const SizedBox(
                    width: 8,
                  ),
                  _getFunButton('性能测定', IconFont.performance,
                      const Color.fromARGB(255, 104, 152, 218)),
                  const SizedBox(
                    width: 8,
                  ),
                  _getFunButton('诊疗记录', IconFont.medical_record,
                      const Color.fromARGB(255, 220, 128, 70)),
                  const SizedBox(
                    width: 8,
                  ),
                ],
              ),
              const SizedBox(height: 8),
              Row(
                children: [
                  const SizedBox(
                    width: 8,
                  ),
                  _getFunButton('配种记录', IconFont.breeding_record,
                      const Color.fromARGB(255, 210, 76, 154)),
                  const SizedBox(
                    width: 8,
                  ),
                  _getFunButton('免疫记录', IconFont.immune,
                      const Color.fromARGB(255, 116, 154, 110)),
                  const SizedBox(
                    width: 8,
                  ),
                  _getFunButton('称重管理', IconFont.weight,
                      const Color.fromARGB(255, 150, 114, 89)),
                  const SizedBox(
                    width: 8,
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  ///banner下方的牛只数量统计
  Expanded _getCountItem(
      String imagePath, String title, int count, IconData iconData) {
    return Expanded(
      child: InkWell(
        onTap: () => {},
        child: Container(
          // height: 90,
          clipBehavior: Clip.hardEdge,
          margin: EdgeInsets.fromLTRB(0, 8, 0, 0),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(5.0),
            boxShadow: [
              BoxShadow(
                color: Colors.black.withOpacity(0.5),
                offset: Offset.zero,
                blurRadius: 5,
                spreadRadius: 0,
              ),
            ],
          ),
          child: Stack(
            fit: StackFit.passthrough,
            children: [
              Image.asset(
                imagePath,
                fit: BoxFit.fitWidth,
              ),
              Positioned(
                left: 10,
                top: 10,
                child: Text(
                  title,
                  style: const TextStyle(
                    color: Colors.white,
                    fontSize: 20,
                  ),
                ),
              ),
              Positioned(
                left: 20,
                bottom: 10,
                child: Text(
                  '${count}',
                  style: const TextStyle(
                    color: Colors.white,
                    fontSize: 20,
                  ),
                ),
              ),
              Positioned(
                right: 30,
                bottom: 5,
                child: Icon(
                  iconData,
                  color: Colors.white,
                  size: 40,
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Expanded _getFunButton(String title, IconData iconData, Color iconColor) {
    return Expanded(
      child: InkWell(
        child: Container(
          height: 80,
          decoration: BoxDecoration(
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: Colors.black.withOpacity(0.1),
                blurRadius: 1,
                spreadRadius: 1,
              )
            ],
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Icon(
                iconData,
                color: iconColor,
                size: 30,
              ),
              Text(title),
            ],
          ),
        ),
        onTap: () => logic.forWard(title),
      ),
    );
  }
}
