import 'package:anchor_collect_flutter/utils/dialog_utils.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../congifs.dart';
import 'login_logic.dart';

class LoginPage extends StatelessWidget {
  const LoginPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    final logic = Get.find<LoginLogic>();

    return Scaffold(
      resizeToAvoidBottomInset: false,
      body: Container(
        padding: EdgeInsets.all(10),
        decoration: const BoxDecoration(
          color: Colors.white,
          // image: DecorationImage(
          //   image: AssetImage('images/ic_login_bg.png'),
          //   fit: BoxFit.cover,
          // ),
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          mainAxisSize: MainAxisSize.max,
          children: [
            const SizedBox(
              height: 80,
            ),
            Image.asset(
              width: 60,
              height: 60,
              'images/ic_launcher.png',
              alignment: Alignment.topCenter,
              fit: BoxFit.cover,
            ),
            const SizedBox(
              height: 20,
            ),
            const Text(
              Config.appName,
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: 20,
                color: Colors.blue,
              ),
            ),
            const SizedBox(
              height: 50,
            ),
            TextField(
              autofocus: true,
              // textInputAction: TextInputAction.continueAction,//加上就不弹出软件盘了
              // style: TextStyle(background: Paint().color),
              decoration: InputDecoration(
                filled: true,
                border: OutlineInputBorder(),
                hintText: '请输入您的用户名',
                fillColor: Colors.white,
                contentPadding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 15.0),
                suffixIcon: IconButton(
                  icon: ImageIcon(AssetImage('images/ic_delete.png')),
                  onPressed: () {},
                ),
              ),
              controller: logic.nameController,
            ),
            const SizedBox(
              height: 20,
            ),
            TextField(
              obscureText: true,
              textInputAction: TextInputAction.send,
              decoration: InputDecoration(
                hintText: '请输入您的密码',
                border: OutlineInputBorder(),
                filled: true,
                fillColor: Colors.white,
                contentPadding: EdgeInsets.symmetric(horizontal: 10.0, vertical: 15.0),
                suffixIcon: IconButton(
                  icon: ImageIcon(AssetImage('images/ic_eye_open.png')),
                  onPressed: () {},
                ),
              ),
              controller: logic.passwordController,
            ),
            const SizedBox(
              height: 15,
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Obx(() {
                  return Radio(
                    value: 0,
                    groupValue: logic.groupValue.value,
                    onChanged: (position) => logic.loginTypeChanged(position!),
                  );
                }),
                Text(
                  '离线',
                  style: TextStyle(
                    fontSize: 14,
                    color: Colors.black,
                  ),
                ),
                Obx(() {
                  return Radio(
                    value: 1,
                    groupValue: logic.groupValue.value,
                    onChanged: (position) => logic.loginTypeChanged(position!),
                  );
                }),
                Text(
                  '联机',
                  style: TextStyle(
                    fontSize: 14,
                    color: Colors.black,
                  ),
                ),
              ],
            ),
            Row(children: [
              Expanded(
                child: TextButton(
                  style: ButtonStyle(
                    backgroundColor: MaterialStateProperty.all(Colors.blue),
                    foregroundColor: MaterialStateProperty.all(Colors.white),
                    padding: MaterialStateProperty.all(EdgeInsets.all(15)),
                  ),
                  onPressed: () => logic.login(),
                  child: const Text("登录"),
                ),
              ),
            ]),
            Expanded(
              flex: 1,
              child: SizedBox(),
            ),
            Container(
              child: Obx(() {
                return Text(
                  'v${logic.versionStr}',
                  style: TextStyle(
                    color: Colors.blue,
                  ),
                );
              }),
            ),
          ],
        ),
      ),
    );
  }
}
