import 'package:flutter/material.dart';
class MyBottomNavigationBarItem extends BottomNavigationBarItem {
  MyBottomNavigationBarItem(
    final String name,
    final int currentIndex,
    final int targetIndex,
    final String selectedImageAsset,
    final String unselectedImageAsset,
    final bool isShowPoint,

  ) : super(
    icon: SizedBox(
      width: 24,
      height: 24,
      child:Stack(
        children: [
          Image.asset(
            currentIndex == targetIndex
                ? selectedImageAsset
                : unselectedImageAsset,
          ),
          isShowPoint? Positioned(
              right: 0,
              child:  Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(50),
                  color: Colors.red,
                ),
            width: 8,
            height: 8,
          )):Container()
        ],
      ),
    ),
    label: name,
  );
}
