import 'package:anchor_collect_flutter/pages/home/home_view.dart';
import 'package:anchor_collect_flutter/pages/message/message_view.dart';
import 'package:anchor_collect_flutter/pages/mine/mine_view.dart';
import 'package:anchor_collect_flutter/pages/sync/sync_logic.dart';
import 'package:anchor_collect_flutter/pages/sync/sync_view.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../message/message_logic.dart';
import 'MyBottomNavigationBarItem.dart';
import 'main_logic.dart';

class MainPage extends StatelessWidget {
    final logic = Get.find<MainLogic>();
    final state = Get.find<MainLogic>().state;
    final syncLogic = Get.find<SyncLogic>();
    final messageLogic = Get.find<MessageLogic>();
  static  List<Widget> _pageList = [
    HomePage(),
    MessagePage(),
    SyncPage(),
    MinePage(),
  ];

  final PageController _pageController = PageController(
    initialPage: 0,
  );

  MainPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {

    return Scaffold(
      body: PageView(
        controller: _pageController,
        onPageChanged: (value) {
          state.currentIndex.value = value;
          if(value==1){
            logic.setMessageStatus(false);
          }
        },
        children: _pageList,
      ),
      bottomNavigationBar: Obx(() {
        return BottomNavigationBar(
          currentIndex: state.currentIndex.value,
          type: BottomNavigationBarType.fixed,
          //未选中颜色
          unselectedItemColor: Colors.black,
          // 选中颜色
          selectedItemColor: Colors.green,
          items: [
            MyBottomNavigationBarItem('首页', state.currentIndex.value, 0,
                'images/home_selected.png', 'images/home.png', false),
            MyBottomNavigationBarItem('消息', state.currentIndex.value, 1,
                'images/message_selected.png', 'images/message.png', state.isNewMessage.value),
            MyBottomNavigationBarItem('同步', state.currentIndex.value, 2,
                'images/sync_selected.png', 'images/sync.png', false),
            MyBottomNavigationBarItem('我的', state.currentIndex.value, 3,
                'images/mine_selected.png', 'images/mine.png', false),
          ],
          onTap: (int position) {
            switch(position){
              case 1:
                messageLogic.getMessageCount();
                break;
              case 2:
              syncLogic.queryCount();
                break;
            }
            _pageController.jumpToPage(position);
          },
        );
      }),
    );
  }
}
