import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'message_detail_logic.dart';

class MessageDetailPage extends StatelessWidget {
  MessageDetailPage({Key? key}) : super(key: key);
  final logic = Get.find<MessageDetailLogic>();
  final state = Get.find<MessageDetailLogic>().state;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('消息详情'),
        centerTitle: true,
      ),
      body: Padding(
        padding: const EdgeInsets.all(15.0),
        child: Container(
          decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(4), boxShadow: const [
            BoxShadow(
              color: Colors.black12,
              blurRadius: 2,
            ),
          ]),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              ListTile(
                title: Text(state.entity.title ?? ''),
                titleTextStyle: const TextStyle(
                  color: Colors.blue,
                  fontSize: 16,
                ),
                subtitle: Text(state.entity.createTime ?? ''),
              ),
              SizedBox(
                height: 1,
                child: Container(
                  color: Colors.black12,
                ),
              ),
              ListView.builder(
                  // physics:,
                  shrinkWrap: true,
                  itemCount: state.cattleResumeList.length,
                  itemBuilder: (context, index) {
                    return Padding(
                      padding: const EdgeInsets.all(8.0),
                      child: InkWell(
                        child: Column(
                          children: [
                            SizedBox(
                              height: 1,
                              child: Container(
                                height: 1,
                                color: Colors.black12,
                              ),
                            ),
                            const SizedBox(
                              height: 10,
                            ),
                            Row(
                              children: [
                                const SizedBox(
                                  width: 20,
                                ),
                                const Text(
                                  '可视耳标',
                                  style: TextStyle(fontSize: 14),
                                ),
                                const Expanded(child: SizedBox()),
                                Text(
                                  '${state.cattleResumeList?[index].individualNo ?? ''}>',
                                  style: const TextStyle(
                                    color: Colors.black54,
                                  ),
                                ),
                                const SizedBox(
                                  width: 20,
                                ),
                              ],
                            ),
                            const SizedBox(
                              height: 20,
                            ),
                            Row(
                              children: [
                                const SizedBox(
                                  width: 20,
                                ),
                                const Text(
                                  '点子耳标',
                                  style: TextStyle(fontSize: 14),
                                ),
                                const Expanded(child: SizedBox()),
                                Text(
                                  '${state.cattleResumeList?[index].registrationNo ?? ''}>',
                                  style: const TextStyle(
                                    color: Colors.black54,
                                  ),
                                ),
                                const SizedBox(
                                  width: 20,
                                ),
                              ],
                            ),
                          ],
                        ),
                        onTap: ()=>{
                          logic.queryCattleResume(state.cattleResumeList?[index].unid??''),
                        },
                      ),
                    );
                  }),
            ],
          ),
        ),
      ),
    );
  }
}
