import 'package:anchor_collect_flutter/utils/dialog_utils.dart';
import 'package:anchor_collect_flutter/utils/empty_utils.dart';
import 'package:get/get.dart';

import '../../../api/HttpUtils.dart';
import '../../../api/apis.dart';
import '../../../models/message.dart';
import 'message_list_state.dart';

class MessageListLogic extends GetxController {
  final MessageListState state = MessageListState();

  @override
  void onInit() {
    var type = Get.arguments;
    if (EmptyUtils.isStrNotEmpty(type)) {
      getMessageList(type);
    }
  }

  @override
  void onReady() {
  }

  getMessageList(String type) {
    Map<String, String> parameter = {};
    parameter.putIfAbsent('type', () => type);
    HttpUtils<MessageModel>()
      ..post()
      ..setUrl(APIS.get_message_list)
      ..showLoading()
      ..setIsList()
      ..setParams(parameter)
      ..onResponseList((response) {
        if (EmptyUtils.isListNotEmpty(response)) {
          state.mDataList.clear();
          for (int i = 0; i < response.length; i++) {
            state.mDataList.add(response[i]!);
          }
          update();
        }
      })
      ..onError((msg, code) {
        DialogUtils.showWarningDialog('获取消息列表失败');
      })
      ..build();
  }
}
