import 'package:anchor_collect_flutter/routes/routes.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:isar/isar.dart';

import 'message_list_logic.dart';

class MessageListPage extends StatelessWidget {
  MessageListPage({Key? key}) : super(key: key);
  final logic = Get.find<MessageListLogic>();
  final state = Get.find<MessageListLogic>().state;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('消息列表'),
        centerTitle: true,
      ),
      body: GetBuilder<MessageListLogic>(builder: (logic) {
        return ListView.builder(
          itemCount: state.mDataList.length,
          itemBuilder: (context, index) {
            return InkWell(
              child: ListTile(
                leading: Image.asset('images/avatar.png'),
                title: Text(state.mDataList[index].title ?? ''),
                subtitle: Text(state.mDataList[index].createTime ?? ''),
                trailing: state.mDataList[index].state == '0'
                    ? const Icon(
                  Icons.add_alert_rounded,
                  color: Colors.red,
                )
                    : const SizedBox(),
              ),
              onTap: ()=>{
                Get.toNamed(AppRoute.MESSAGE_DETAIL, arguments: state.mDataList[index]),
              },
            );
          },
        );
      }),
    );
  }
}
