
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'message_logic.dart';

class MessagePage extends StatelessWidget {
  MessagePage({Key? key}) : super(key: key);
  final logic = Get.find<MessageLogic>();
  final state = Get.find<MessageLogic>().state;

  @override
  Widget build(BuildContext context) {
    logic.getListData();
    return Scaffold(
      appBar: AppBar(
        title: const Text('生产提醒'),
        centerTitle: true,
      ),
      body: GetBuilder<MessageLogic>(builder: (logic) {
        return GridView.builder(
          padding: EdgeInsets.all(8),
          gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
            crossAxisCount: 3, // 横轴上Item个数
            crossAxisSpacing: 8, // 横轴上Item间距
            mainAxisSpacing: 8, // 主轴上Item间距
            // mainAxisExtent: 100, // 主轴上Item长度
            childAspectRatio: 1.5, // 横轴长度/主轴长度
          ),
          itemCount: state.items.length,
          itemBuilder: (BuildContext context, int index) {
            return state.items[index];
          },
        );
      }),
    );
  }
}
