import 'package:anchor_collect_flutter/congifs.dart';
import 'package:flutter/material.dart';

class MessageItem extends StatelessWidget {
  final String title;
  final IconData iconData;
  final Color iconColor;
  final int count;

  Function() onItemClick;

  MessageItem(
      {super.key,
      required this.title,
      required this.iconData,
      required this.iconColor,
      required this.count,
      required this.onItemClick});

  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.center,
      decoration: BoxDecoration(
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: Colors.black.withOpacity(0.1),
            blurRadius: 1,
            spreadRadius: 1,
          )
        ],
      ),
      child: InkWell(
        child: Stack(alignment: Alignment.center, children: [
          Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Icon(
                iconData,
                color: iconColor,
                size: 30,
              ),
              Text(title),
            ],
          ),
          count > 0
              ? Positioned(
                  top: 5,
                  right: 0,
                  child: Container(
                    height: 20,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      color: Colors.red,
                      borderRadius: BorderRadius.circular(20),
                    ),
                    child: Padding(
                      padding: const EdgeInsets.fromLTRB(6.0, 0, 6.0, 0),
                      child: Text(
                        '$count',
                        style: const TextStyle(fontSize: 12, color: Colors.white),
                      ),
                    ),
                  ),
                )
              : Container(),
        ]),
        onTap: () => {
          onItemClick.call(),
        },
      ),
    );
  }
}
