import 'dart:ui';

import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../congifs.dart';
import 'sync_logic.dart';

class SyncPage extends StatelessWidget {
  SyncPage({Key? key}) : super(key: key);
  final logic = Get.find<SyncLogic>();
  final state = Get.find<SyncLogic>().state;

  @override
  Widget build(BuildContext context) {
    logic.getSyncItemList();

    return Scaffold(
      appBar: AppBar(
        title: const Text('数据同步'),
        centerTitle: true,
        actions: [
          InkWell(
            child: const Icon(
              Icons.save,
              color: Colors.red,
            ),
            onTap: () {},
          ),
        ],
      ),
      body: Column(
        children: <Widget>[
          Expanded(
            child: GetBuilder<SyncLogic>(builder: (logic) {
              return ListView.builder(
                shrinkWrap: true,
                itemCount: state.items.length,
                itemBuilder: (context, index) {
                  return state.items[index];
                },
              );
            }),
          ),
          Row(
            children: [
              const SizedBox(width: 10),
              Expanded(
                child: Config.isOnLine?TextButton(
                  style: ButtonStyle(
                    padding: MaterialStateProperty.all(const EdgeInsets.all(10)),
                    foregroundColor: MaterialStateProperty.all(Colors.white),
                    backgroundColor: MaterialStateProperty.all(Colors.blue),
                  ),
                  onPressed: () =>{
                    logic.syncData(),
                  },
                  child: const Text('一键同步'),
                ):const SizedBox(),
              ),
              const SizedBox(width: 10),
            ],
          ),
          const SizedBox(height: 10),
        ],
      ),
    );
  }
}
