import 'package:anchor_collect_flutter/pages/main/main_binding.dart';
import 'package:anchor_collect_flutter/pages/main/main_view.dart';
import 'package:anchor_collect_flutter/pages/message/message_binding.dart';
import 'package:anchor_collect_flutter/pages/message/message_view.dart';
import 'package:anchor_collect_flutter/pages/mine/mine_binding.dart';
import 'package:anchor_collect_flutter/pages/mine/mine_view.dart';
import 'package:anchor_collect_flutter/pages/setting/setting_binding.dart';
import 'package:anchor_collect_flutter/pages/setting/setting_view.dart';
import 'package:anchor_collect_flutter/pages/sync/sync_binding.dart';
import 'package:anchor_collect_flutter/pages/sync/sync_view.dart';
import 'package:get/get.dart';
import '../pages/camera/camera_binding.dart';
import '../pages/camera/camera_view.dart';
import '../pages/cattle_resume/cattle_resume_binding.dart';
import '../pages/cattle_resume/cattle_resume_list/cattle_resume_list_binding.dart';
import '../pages/cattle_resume/cattle_resume_list/cattle_resume_list_view.dart';
import '../pages/cattle_resume/cattle_resume_view.dart';
import '../pages/home/home_binding.dart';
import '../pages/home/home_view.dart';
import '../pages/login/login_binding.dart';
import '../pages/login/login_view.dart';
import '../pages/message/message_detail/message_detail_binding.dart';
import '../pages/message/message_detail/message_detail_view.dart';
import '../pages/message/message_list/message_list_binding.dart';
import '../pages/message/message_list/message_list_view.dart';
import 'routes.dart';

abstract class AppPages {
  static final List<GetPage> pages = [
    GetPage(
      name: AppRoute.LOGIN,
      page: () => const LoginPage(),
      binding: LoginBinding(),
    ),
    GetPage(
      name: AppRoute.MAIN,
      page: () => MainPage(),
      binding: MainBinding(),
    ),
    GetPage(
      name: AppRoute.HOME,
      page: () =>  HomePage(),
      binding: HomeBinding(),
    ),
    GetPage(
      name: AppRoute.MESSAGE,
      page: () =>  MessagePage(),
      binding: MessageBinding(),
    ),
    GetPage(
      name: AppRoute.MESSAGE_LIST,
      page: () =>  MessageListPage(),
      binding: MessageListBinding(),
    ),
    GetPage(
      name: AppRoute.MESSAGE_DETAIL,
      page: () =>  MessageDetailPage(),
      binding: MessageDetailBinding(),
    ),
    GetPage(
      name: AppRoute.SYNC,
      page: () => SyncPage(),
      binding: SyncBinding(),
    ),
    GetPage(
      name: AppRoute.MINE,
      page: () => const MinePage(),
      binding: MineBinding(),
    ),
    GetPage(
      name: AppRoute.CATTLE_RESUME_LIST,
      page: () =>  CattleResumeListPage(),
      binding: CattleResumeListBinding(),
    ),
    GetPage(
      name: AppRoute.CATTLE_RESUME,
      page: () =>  CattleResumePage(),
      binding: CattleResumeBinding(),
    ),
    GetPage(
      name: AppRoute.CAMERA,
      page: () =>  CameraPage(),
      binding: CameraBinding(),
    ),
    GetPage(
      name: AppRoute.SETTING,
      page: () =>  SettingPage(),
      binding: SettingBinding(),
    ),
  ];
}
