import 'dart:html';

import 'package:flutter/material.dart';
import 'package:cached_network_image/cached_network_image.dart';

class ImageUtils {
  static String errorHeadImg = 'images/img_head.png';
  static String errorImg = 'images/img_error.png';

  static Widget loadHead(
    String imageUrl,
    double? size, {
    double? borderRadius = 0.0,
  }) {
    return CachedNetworkImage(
      width: size,
      height: size,
      imageUrl: imageUrl,
      imageBuilder: (context, image) {
        return ClipRRect(
          borderRadius: BorderRadius.circular(borderRadius ?? 0.0),
          child: Image(image: image, fit: BoxFit.cover),
        );
      },
      placeholder: (context, url) => Center(child: CircularProgressIndicator()),
      errorWidget: (context, url, error) {
        return Image.asset(
          errorHeadImg,
          height: size,
          width: size,
        );
      },
    );
  }

  static Widget load(String imageUrl,
      {double? width,
      double? height,
      double? borderRadius = 0.0,
      Widget? error}) {
    return width != null
        ? CachedNetworkImage(
            width: width,
            height: height,
            imageUrl: imageUrl,
            imageBuilder: (context, image) {
              return ClipRRect(
                borderRadius: BorderRadius.circular(borderRadius ?? 0.0),
                child: Image(image: image, fit: BoxFit.cover),
              );
            },
            placeholder: (context, url) =>
                Center(child: CircularProgressIndicator()),
            errorWidget: (context, url, e) {
              return error ??
                  Image.asset(
                    width: width,
                    height: height,
                    errorImg,
                  );
            },
          )
        : CachedNetworkImage(
            imageUrl: imageUrl,
            imageBuilder: (context, image) {
              return ClipRRect(
                borderRadius: BorderRadius.circular(borderRadius ?? 0.0),
                child: Image(image: image, fit: BoxFit.cover),
              );
            },
            placeholder: (context, url) =>
                Center(child: CircularProgressIndicator()),
            errorWidget: (context, url, e) {
              return error ??
                  Image.asset(
                    errorImg,
                  );
            },
          );
  }

}
