import 'dart:convert';
import 'dart:io';
import 'dart:typed_data';

import 'package:anchor_collect_flutter/utils/storage_utils.dart';

class Base64Utils {
  static Future<String> fileToBase64(String imagePath) async {
    // 读取本地文件
    final File imageFile = File(imagePath);
    // 将文件转换为Uint8List
    final Uint8List imageBytes = await imageFile.readAsBytes();
    // 使用base64编码将图片字节转换为Base64字符串
    final String base64String = base64.encode(imageBytes);

    return base64String;
  }

  static Future<String> base64ToFile(String photo, String unid) async {
    Uint8List bytes = base64.decode(photo);
    String fullPath = StorageUtils.getPath(unid ?? '');
    print("local file full path ${fullPath}");
    File file = File(fullPath);
    await file.writeAsBytes(bytes);

    return fullPath;
  }
}
