import 'package:anchor_collect_flutter/models/value_model.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_smart_dialog/flutter_smart_dialog.dart';
import 'package:intl/intl.dart';

class MultipleModel {
  String name;
  String value;
  bool selected;

  MultipleModel(this.name, this.value, this.selected);
}

class DialogUtils {
  static late TextEditingController textEditingController;

  static void showToast(String content) {
    SmartDialog.showToast(content);
  }

  static showLoadingDialog(String msg, {bool backDismiss = true, bool clickMaskDismiss = false}) {
    SmartDialog.showLoading(
      msg: msg,
      backDismiss: backDismiss,
      clickMaskDismiss: clickMaskDismiss,
    );
  }

  static dismissDialog() {
    SmartDialog.dismiss();
  }

  ///提示框
  static showWarningDialog(String content) {
    SmartDialog.show(
        backDismiss: true,
        clickMaskDismiss: false,
        builder: (_) {
          return Center(
              child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Container(
                margin: const EdgeInsets.fromLTRB(60, 10, 60, 10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: Colors.white,
                ),
                child: Column(children: <Widget>[
                  Container(
                    constraints: const BoxConstraints(maxHeight: 500),
                    padding: const EdgeInsets.fromLTRB(0, 0, 0, 0),
                    margin: const EdgeInsets.fromLTRB(16, 10, 16, 10),
                    child: Text(
                      content,
                      style: const TextStyle(
                        fontSize: 18,
                      ),
                    ),
                  ),
                  SizedBox(
                    width: double.infinity,
                    height: 45,
                    child: Row(
                      children: [
                        Expanded(
                          child: TextButton(
                            onPressed: () {
                              SmartDialog.dismiss();
                            },
                            child: const Text(
                              '确定',
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ]),
              ),
            ],
          ));
        });
  }

  ///输入框
  static showInputDialog({
    String title = '请输入',
    String content = '',
    String hintText = '',
    String buttonOk = '确定',
    String buttonCancel = '取消',
    int maxLength = 50,
    bool backDismiss = true,
    bool clickMaskDismiss = false,
    void Function(String)? onPositive,
    void Function()? onNegative,
  }) {
    SmartDialog.show(
        backDismiss: backDismiss,
        clickMaskDismiss: clickMaskDismiss,
        builder: (_) {
          textEditingController = TextEditingController();
          return Center(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Container(
                  margin: const EdgeInsets.fromLTRB(60, 0, 60, 0),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: Colors.white,
                  ),
                  child: Column(
                    children: <Widget>[
                      title != ''
                          ? Container(
                              margin: const EdgeInsets.fromLTRB(16, 10, 16, 10),
                              child: Text(
                                title,
                                style: const TextStyle(
                                  fontSize: 18,
                                ),
                              ),
                            )
                          : const SizedBox(),
                      Container(
                        padding: const EdgeInsets.fromLTRB(0, 0, 0, 0),
                        margin: const EdgeInsets.fromLTRB(16, 0, 16, 0),
                        constraints: const BoxConstraints(maxHeight: 500),
                        child: TextField(
                          controller: textEditingController,
                          maxLength: maxLength,
                          decoration: InputDecoration(
                            border: const OutlineInputBorder(),
                            hintText: hintText,
                          ),
                        ),
                      ),
                      SizedBox(
                        width: double.infinity,
                        height: 45,
                        child: Row(
                          children: [
                            Expanded(
                              child: TextButton(
                                onPressed: () {
                                  SmartDialog.dismiss();
                                  onNegative?.call();
                                },
                                child: Text(buttonCancel),
                              ),
                            ),
                            Expanded(
                              child: TextButton(
                                onPressed: () {
                                  textEditingController.dispose();
                                  onPositive?.call(textEditingController.text);
                                  SmartDialog.dismiss();
                                },
                                child: Text(buttonOk),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          );
        });
  }

  ///单选框
  static void showSingleListDialog(
    List<ValueModel> nameList, {
    String title = '请选择',
    String buttonOk = '确定',
    String buttonCancel = '取消',
    bool backDismiss = true,
    bool clickMaskDismiss = false,
    void Function(ValueModel)? onPositive,
    void Function()? onNegative,
  }) {
    SmartDialog.show(
        backDismiss: backDismiss,
        clickMaskDismiss: clickMaskDismiss,
        builder: (_) {
          return Center(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Container(
                  margin: const EdgeInsets.fromLTRB(60, 0, 60, 0),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: Colors.white,
                  ),
                  child: Column(
                    children: <Widget>[
                      title != ''
                          ? Container(
                              margin: const EdgeInsets.fromLTRB(16, 10, 16, 10),
                              child: Text(
                                title,
                                style: const TextStyle(
                                  fontSize: 18,
                                ),
                              ),
                            )
                          : const SizedBox(),
                      Container(
                        padding: const EdgeInsets.fromLTRB(0, 0, 0, 0),
                        margin: const EdgeInsets.fromLTRB(16, 0, 16, 0),
                        constraints: const BoxConstraints(maxHeight: 500),
                        child: ListView.builder(
                            shrinkWrap: true,
                            itemCount: nameList.length,
                            itemBuilder: (context, index) {
                              return TextButton(
                                  onPressed: () {
                                    onPositive?.call(nameList[index]);
                                    SmartDialog.dismiss();
                                  },
                                  child: Text(
                                    nameList[index].key,
                                    style: const TextStyle(color: Colors.black),
                                  ));
                            }),
                      ),
                      SizedBox(
                        width: double.infinity,
                        height: 45,
                        child: Row(
                          children: [
                            Expanded(
                              child: TextButton(
                                onPressed: () {
                                  SmartDialog.dismiss();
                                  onNegative?.call();
                                },
                                child: Text(buttonCancel),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          );
        });
  }

  ///多选框
  static showMultipleListDialog(
    List<String> nameList,
    List<String> valueList, {
    String title = '请选择',
    String buttonOk = '确定',
    String buttonCancel = '取消',
    bool backDismiss = true,
    bool clickMaskDismiss = false,
    void Function(String)? onPositive,
    void Function()? onNegative,
  }) {
    var controller = SmartDialogController();

    List<MultipleModel> itemEntity = [];
    if (nameList.length != valueList.length) {
      return;
    }
    for (int i = 0; i < nameList.length; i++) {
      itemEntity.add(MultipleModel(nameList[i], valueList[i], false));
    }

    SmartDialog.show(
        backDismiss: backDismiss,
        clickMaskDismiss: clickMaskDismiss,
        controller: controller,
        builder: (_) {
          return Center(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Container(
                  margin: const EdgeInsets.fromLTRB(60, 0, 60, 0),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: Colors.white,
                  ),
                  child: Column(
                    children: <Widget>[
                      title != ''
                          ? Container(
                              margin: const EdgeInsets.fromLTRB(16, 10, 16, 10),
                              child: Text(
                                title,
                                style: const TextStyle(
                                  fontSize: 18,
                                ),
                              ),
                            )
                          : const SizedBox(),
                      Container(
                        padding: const EdgeInsets.fromLTRB(0, 0, 0, 0),
                        margin: const EdgeInsets.fromLTRB(16, 0, 16, 0),
                        constraints: const BoxConstraints(maxHeight: 500),
                        child: ListView.builder(
                            shrinkWrap: true,
                            itemCount: nameList.length,
                            itemBuilder: (context, index) {
                              return CheckboxListTile(
                                  title: Text(itemEntity[index].name),
                                  value: itemEntity[index].selected,
                                  onChanged: (isSelected) {
                                    itemEntity[index].selected = isSelected!;
                                    controller.refresh();
                                  });
                            }),
                      ),
                      SizedBox(
                        width: double.infinity,
                        height: 45,
                        child: Row(
                          children: [
                            Expanded(
                              child: TextButton(
                                onPressed: () {
                                  SmartDialog.dismiss();
                                  onNegative?.call();
                                },
                                child: Text(buttonCancel),
                              ),
                            ),
                            Expanded(
                              child: TextButton(
                                onPressed: () {
                                  String result = '';
                                  for (int i = 0; i < itemEntity.length; i++) {
                                    if (itemEntity[i].selected) {
                                      result += itemEntity[i].value;
                                      result += ',';
                                    }
                                  }
                                  onPositive?.call(result);
                                  SmartDialog.dismiss();
                                },
                                child: Text(buttonOk),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          );
        });
  }

  ///时间选择框
  static showTimeDialog(
    BuildContext context, {
    String title = '请选择',
    String buttonOk = '确定',
    String buttonCancel = '取消',
    bool isTime = false,
    void Function(String)? onPositive,
    void Function()? onNegative,
  }) async {
    if (isTime) {
      TimeOfDay? timeDay = await showTimePicker(context: context, initialTime: TimeOfDay.now());
      if (kDebugMode) {
        print('why:time_day$timeDay');
      }
      onPositive?.call(timeDay.toString());
    } else {
      var selectDayTime = await showDatePicker(
        context: context,
        initialDate: DateTime.now(), //起始时间
        firstDate: DateTime(2020, 5, 1), //最小可以选日期
        lastDate: DateTime(2030, 5, 1), //最大可选日期
      );
      if(selectDayTime!=null) {
        final dateFormatter = DateFormat('yyyy-MM-dd');
        final dateString = dateFormatter.format(selectDayTime);
      if (kDebugMode) {
        print('why:select_day_time$dateString');
      }
      onPositive?.call(dateString);
      }
    }
  }
}
