import 'package:anchor_collect_flutter/models/dict_entity.dart';
import 'package:anchor_collect_flutter/models/value_model.dart';
import 'package:isar/isar.dart';

import '../controllers/global_service.dart';

class DictUtils {
  static Future<List<ValueModel>> getDictList(String type) async {

    List<ValueModel> valueModelList = [];
    List<DictEntity> dictList = await GlobalService.to.isar.dictEntitys
        .filter()
        .dictTypeEqualTo(type)
        .findAll();
    for (int i = 0; i < dictList.length; i++) {
      valueModelList.add(ValueModel(dictList[i].dictLabel??'', dictList[i].dictValue??''));
    }
  return valueModelList;
  }

  static Future<String> getDictName(String type, String value) async {
    List<ValueModel> list = await getDictList(type);

    for (int i = 0; i < list.length; i++) {
      if (list[i].value == value) {
        return list[i].key ?? '';
      }
    }
    return '';
  }

}
